/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.peripherals.iec.sim;

import emulator.hardware.io.peripherals.iec.sim.Action;
import emulator.hardware.io.peripherals.iec.sim.Edge;
import emulator.hardware.io.peripherals.iec.sim.Event;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MachineState {
    static Logger logger = LogManager.getLogger((String)MachineState.class.getName());
    private String _name;
    private List<Edge> _edges = new LinkedList<Edge>();

    public MachineState(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public MachineState next() throws Exception {
        try {
            for (Edge edge : this._edges) {
                if (!edge.isActive()) continue;
                return edge.execute();
            }
        }
        catch (Exception ex) {
            logger.error("Failed to handle state " + this.getName(), (Throwable)ex);
            throw ex;
        }
        return this;
    }

    public MachineState addEdge(Event event, Action action, MachineState nextState) {
        this._edges.add(new Edge(event, action, nextState));
        return this;
    }

    public MachineState enter() {
        return this;
    }
}

